*****************************************************************************
*
*       Apple IIgs New Printer Driver
*
*       File: dialog.asm --
*             Doing dialog boxes, thereby modifying user's print record
*
*       Written by Ben Koning                                                 
*       Modified by Matt Deatherage
*       Copyright (C) 1990 Apple Computer, Inc.                               
*
*****************************************************************************


             mcopy dialog.macros
             copy  drvrequates.asm
             copy  2/ainclude/e16.window
             copy  2/ainclude/e16.control

*
*STATUS MESSAGE ROUTINES:
*StartStatusMessage/FinishStatusMessage/StatusMessage/StatusManFeedPrompt
*These routines can display messages for the user.  After calling
*StartStatusMessage, calling StatusMessage with ParamLongA pointing to a
*string will cause that string to be shown, centered, in a centered dialog
*box (640/320 mode automatically taken care of).  StatusManFeedPrompt will
*put up a caution alert asking the user to insert the next sheet, to be
*numbered with the value given in ParamWordA.  Call FinishStatusMessage when
*done, erasing the dialog box.
*

*
*STARTSTATUSMESSAGE: Draw box used by "StatusMessage"; calc to prepare for
*"StatusMesgFeedPrompt":
*
StartStatusMessage START
            USING  PicterData

            _WaitCursor          ;put up wait cursor

* modify the dialog coordinates

            lda    StatusWindowCoordX2
            sec
            sbc    StatusWindowCoordX1  ;calc size (silly at runtime)
            sta    StatusWindowWidth    ;save size
            pha                         ;result space for scb
            _GetMasterSCB
            pla
            ldx    #640                 ;assume 640 mode for a sec
            and    #$80                 ;look at mode bit (1=640, 0=320)
            bne    StMeMode640
            ldx    #320                 ;change assumption made above
StMeMode640 txa
            sec
            sbc    StatusWindowWidth    ;acc now has [320|640] - (X2-X1)
            lsr    a                    ;divide by two
            sta    StatusWindowCoordX1  ;this is left coordinate of box
            sta    ManFeedAlertTempCoordX1 ;also for man feed alert template
            clc
            adc    StatusWindowWidth    ;maintain proper size of box
            sta    StatusWindowCoordX2  ;this is right coordinate of box
            sta    ManFeedAlertTempCoordX2 ;also for man feed alert template

            pha                          ;result space for window grafport...
            pha
            pushlong #StatusWindowTemp  ;draw window from template
            _NewWindow                  ;this does NOT set current grafport!
            pulllong StatusWindowPtr    ;save our ticket to access the box
            lda    #1                   ;indicate it's ok to use it now
            sta    StatusWindowExists
            rts

            END
*
*FINISHSTATUSMESSAGE: Removes the box displayed above; won't crash if called
*alone; normal cursor:
*

FinishStatusMessage START
            USING  PicterData

            lda StatusWindowExists   ;was it ever really drawn?
            beq    FiStExit             ;if not, don't do CloseWindow
            pushlong StatusWindowPtr    ;erase window and dispose memory
            _CloseWindow
            _InitCursor                 ;remove wait cursor
            stz    StatusWindowExists   ;it's gone now
FiStExit    rts

            END
*
*STATUSMESSAGE: Draws centered string at "ParamLongA" into above-opened
*message box; uninit-proof:
*

StatusMessage START
            USING  PicterData

            lda  StatusWindowExists   ;was window ever drawn?
            beq    StMeExit             ;if not, abort this routine
            pha                         ;result space...
            pha
            _GetPort                    ;save old grafport on stack
            pushlong StatusWindowPtr    ;set grafport to box's port...
            _SetPort
            pushlong #StMeBigRect       ;clear box contents...
            _EraseRect
            pha                         ;result space
            pushlong ParamLongA         ;push pointer to our messgae
            _StringWidth                ;ask what size it will be
            lda    StatusWindowWidth    ;leave result on stack
            sec                         ;for subtract right on the stack
            sbc    1,s                  ;acc now has (X2-X1) - width
            lsr    a                    ;divide by two; acc now has X coord
            sta    1,s                  ;this is start X coordinate for text
            pushword StatusWindowTextY  ;this is start Y coordinate for text
            _MoveTo                     ;move the pen to pushed coordinates
            pushlong ParamLongA         ;and draw the string...
            _DrawString
            _SetPort                    ;restore old grafport from stack
StMeExit    rts

*Big rectangle to clear status box contents:
StMeBigRect dc     i2'0,0,200,320'

            END



*
*STATUSMESGFEEDPROMPT: Prompts to insert "ParamWordA"-th page; call after
*"StartStatusMessage":  This routine exits with carry set if cancel option was
*selected by user.
*

StatusMesgFeedPrompt START
            USING PicterData

            lda StatusWindowExists
            beq    StFeExit
            pushword ParamWordA         ;int to be converted to string
            pushlong #ManFeedAlertTempPageNo ;where number ascii data goes
            pushword #5                 ;length
            pushword #0                 ;unsigned
            _Int2Dec                    ;convert and store it
            pha                         ;result space
            pushlong #ManFeedAlertTemp  ;template
            pushlong #0                 ;no filter proc
            _NoteAlert
            pla                         ;get item id that was selected
            cmp    #mesgFeedPromptNGButtID ;set carry only if cancel selected
            beq    StFeExit
            clc
StFeExit    rts

            END
*
*NOTCORRECTDEVDIALOG: Displays message about correct printer not being
*connected; call anytime:
*
NotCorrectDevDialog START
            USING  PicterData

            lda DevAlertTempCoordX2  ;modify dialog coordinates...
            sec
            sbc    DevAlertTempCoordX1  ;calc size (silly at runtime)
            sta    NoCoDiXSize          ;save size
            pha                         ;result space for scb
            _GetMasterSCB
            pla
            ldx    #640                 ;assume 640 mode for a sec
            and    #$80                 ;look at mode bit (1=640, 0=320)
            bne    NoCoDiMode640
            ldx    #320                 ;change assumption made above
NoCoDiMode640 txa
            sec
            sbc    NoCoDiXSize          ;acc now has [320|640] - (X2-X1)
            lsr    a                    ;divide by two
            sta    DevAlertTempCoordX1  ;this is left coordinate of box
            clc
            adc    NoCoDiXSize          ;maintain proper X size of box
            sta    DevAlertTempCoordX2  ;this is right coordinate of box
            pha                         ;result space
            pushlong #DevAlertTemp      ;template
            pushlong #0                 ;no filter proc
            _NoteAlert                  ;do the dialog until button hit
            pla                         ;we don't care about which item hit
            rts
*For calculating horizontally centered/sized box:
NoCoDiXSize dc     i2'0'

            END
*
*CONDUCT-DIALOG-ROUTINES: These routines handle the dialog boxes for
*gathering the information to modify the print record.
*


*
*CONDUCTSTYLEDIALOG: Does Start/FinishDialog/TaskMaster, does metrics
*routines to change print record. On exit, accumulator is set/cleared
*depending on OK/Cancel selection:
*
*Modify dialog data to reflect settings of current print record:  This would
*be much more elegant if only the dialog ID's could be the same as the data in
*the print record...

ConductStyleDialog START
            USING  PicterData

            jsr GetOutputPortName     ;fill-in "Printer/Port" string

            jsr    GetPaper
            clc
            adc    #paperTypeUSALtrItemID    ;convert id # to dialog id
            sta    paperTypeInitValue
*
            jsr    GetReduction
            clc
            adc    #reductionFullSizeItemID  ;convert to dialog id
            sta    reductionInitValue
*
            stz    effectsNoGapsInitValue
            jsr    GetPageGap
            beq    CoStNext1
            lda    #1
            sta    effectsNoGapsInitValue
*
CoStNext1   stz    effectsCondensedInitValue
            jsr    GetVSize
            beq    CoStNext2
            lda    #1
            sta    effectsCondensedInitValue

CoStNext2   jsr    GetOrientation
            sta    CoStOrientationState        ;we do this ourselves

*Now go draw the window with all the controls:

            lda    #StyleControlTemp    ;get address of control template
            sta    ParamLongA+0         ;list for this dialog box
            lda    #StyleControlTemp|-16
            sta    ParamLongA+2
            jsr    StartDialog          ;draw dialog window and controls

*Setup our TaskMask to handle keyboard events:
            lda    #DialogTaskMaskYesKeys|-16     ;need change hi word only
            sta    DialogTaskMask+2

*Take events until OK or CANCEL:
CoStEventLoop pha                       ;result space
            pushword #$FFFF             ;event mask for taskmaster
            pushlong #DialogTaskRecord  ;where to stuff event data
            _TaskMaster                 ;go handle events in window
            pla                         ;get result code

*Redraw ctls for update evt.  Rely on at least 1 update event @ first to
*invert apt port/land icon:
            cmp    #6                   ;update event?
            beq    CoStIsUpdate1
            brl    CoStNotUpdate
CoStIsUpdate1 ldx  DialogWindowPtr+0    ;check it's our window
            cpx    DialogTaskData+0
            beq    CoStIsUpdate2
            brl    CoStNotUpdate
CoStIsUpdate2 ldy  DialogWindowPtr+2
            cpy    DialogTaskData+2
            beq    CoStIsUpdate3
            brl    CoStNotUpdate
CoStIsUpdate3 ANOP
*
            phy                         ;prepare to redraw all contents
            phx
            _BeginUpdate
*
            pushlong DialogWindowPtr    ;recreate all control handles
            _KillControls               ;because port/land were deleted
            pha
            pha
            pushlong DialogWindowPtr
            pushword #3
            pushlong #StyleControlTemp
            _NewControl2
            pla
            pla
*
            jsr    RedrawDialog         ;do redrawing
*
            pha                         ;dump port/land so won't track
            pha
            pushlong DialogWindowPtr
            pushlong #orientationPortraitItemID
            _GetCtlHandleFromID
            _DisposeControl
            pha
            pha
            pushlong DialogWindowPtr
            pushlong #orientationLandscapeItemID
            _GetCtlHandleFromID
            _DisposeControl
*               
            lda    CoStOrientationState ;do inverting of port/land
            cmp    #1
            beq    CoStRedrawIItsLand
CoStRedrawIItsPort pushlong #orientationPortraitRect
            bra    CoStRedrawInvert
CoStRedrawIItsLand pushlong #orientationLandscapeRect
CoStRedrawInvert _InvertRect
*
            pushlong DialogWindowPtr    ;done redrawing all contents
            _EndUpdate
*
            brl    CoStEventLoop        ;go handle another event
CoStNotUpdate ANOP

*Begin check for our own manual "icon radio buttons":
            cmp    #wInContent          ;mouse down on icon(?) event yet?
            beq    CoStCheckIconButtons ;yes, so check icon buttons
            brl    CoStCheckOtherCtrl   ;no, check other events

*Do our "icon radio buttons" entirely ourselves:
CoStCheckIconButtons pushlong #DialogWhere   ;modify  coordinates...
            _GlobalToLocal              ;... to window coordinates
            pha                         ;result space
            pushlong #DialogWhere       ;check our point...
            pushlong #orientationPortraitRect     ;...against portrait icon
            _PtInRect
            pla
            beq    CoStNotPortrait      ;it's not in portrait icon
            lda    CoStOrientationState ;mouse is down in portrait
            bne    CoStFlipOrientation  ;we were in landscape, flip 'em
            brl    CoStEventLoop        ;forget it, already in portrait
*
CoStNotPortrait pha                     ;result space
            pushlong #DialogWhere       ;check our point...
            pushlong #orientationLandscapeRect    ;...against landscape icon
            _PtInRect
            pla
            beq    CoStCheckOtherCtrl   ;it's not in landscape icon
            lda    CoStOrientationState ;mouse is now down in landscape
            beq    CoStFlipOrientation
            brl    CoStEventLoop
CoStFlipOrientation eor #1                    ;flip bit
            sta    CoStOrientationState       ;remember it
            pushlong #orientationPortraitRect ;invert both icons, thus moving
            _InvertRect                       ;the highlight to the other one
            pushlong #orientationLandscapeRect
            _InvertRect
            brl    CoStEventLoop               ;were done; go for more

*Handle other control events:                           
CoStCheckOtherCtrl cmp #$0021           ;wInControl event yet?
            beq    CoStGotCtrl
            brl    CoStEventLoop        ;...loop until such event
CoStGotCtrl lda    DialogTaskData4      ;get lo order control item ID

*Just get out if Cancel selected:
            cmp    #cancelItemID        ;if Cancel, let's exit
            bne    CoStNotCancel
            jsr    FinishDialog         ;dump dialog box
            lda    #0                   ;confirmFlag will be false
            rts

*Resume event handling if OK was not selected:
CoStNotCancel cmp  #okItemID            ;if OK, go save stuff & exit
            beq    CoStOkSelected
            brl    CoStEventLoop        ;else resume event handling

*Save stuff in print record before leaving if OK selected:
CoStOkSelected lda CoStOrientationState ;do this  first; it's unique
            sta    OptionA
            jsr    SetOrientation
*
            lda    #paperTypeItemID
            jsr    GetControlValue
            sec
            sbc    #paperTypeUSALtrItemID ;normalize
            sta    OptionA
            jsr    SetPaper
*
            lda    #reductionItemID
            jsr    GetControlValue
            sec
            sbc    #reductionFullSizeItemID  ;normalize
            sta    OptionA
            jsr    SetReduction
*
            lda    #effectsNoGapsItemID
            jsr    GetControlValue
            sta    OptionA
            jsr    SetPageGap
*
            lda    #effectsCondensedItemID
            jsr    GetControlValue
            sta    OptionA
            jsr    SetVSize

*Now get rid of box, validate print record because it changed, and exit with
*ACC set:
            jsr    FinishDialog         ;dump dialog box
            jsr    CalcMetrics          ;make sure it's self-consistent
            lda    #1                   ;confirmFlag will be true
            rts

*DATA: Keeping track of the "icon radio buttons" which we are doing ourselves:

CoStOrientationState dc i2'0'           ;0=portrait; 1=landscape

            END

*
*CONDUCTJOBDIALOG: Does dialogs/TaskMaster, metrics/change print record,
*checks installed options by communicating to printer.  If error happens
*during communication, returns with tool error set.
*On exit, ACC is set if OK was selected:
*

ConductJobDialog   START
            USING  PicterData

            jsr GetOutputPortName  ;fill-in "printer/port" string

*Make dialogdata contain values from print record EXCEPT page range and
*number of copies:

            jsr    GetQuality
            clc
            adc    #printQualityStandardItemID
            sta    printQualityInitValue
*                           
            jsr    GetColor
            php
            ldy    #chromaMonochromeItemID
            plp
            beq    CoJoSetIt2
            iny
CoJoSetIt2  sty    chromaInitValue
*
            jsr    GetFeed
            php
            ldy    #pageFeedManualItemID
            plp
            beq    CoJoSetIt3
            iny
CoJoSetIt3  sty    pageFeedInitValue
;
; Here is where you should check the printer for options (like color
; ribbons) and disable items in the dialog that aren't available.
;

*Set default page range and copies just like in what PrDefault would do:
            lda    #1
            sta    OptionA
            lda    #32767
            sta    OptionB
            jsr    SetPageRange
            jsr    SetCopies

*Now set up the LE boxes, and set the All/From-To radio button states:

            shortm
            stz    pagesFromBoxString   ;reset from/to LE box lengths to zero
            stz    pagesToBoxString
            lda    #'1'                 ;but put "1" in #-of-copies LE box
            sta    copiesBoxString+1
            lda    #1
            sta    copiesBoxString
            sta    pagesAllInitValue    ;set default "All" pages radio button
            stz    pagesRangeInitValue
            longm

*Now draw the window with all the controls:
            lda    #JobControlTemp      ;get address of control template
            sta    ParamLongA+0
            lda    #JobControlTemp|-16
            sta    ParamLongA+2
            jsr    StartDialog          ;draw window with controls

*Setup TaskMask not to handle keyboard events:
            lda    #DialogTaskMaskNoKeys|-16 ;need change hi word only...
            sta    DialogTaskMask+2

*Get LineEdit (LE) handle ready for Copies item and then go to event loop.
*ParamLongA has LE handle:

            pha
            pha
            pushlong DialogWindowPtr
            pushlong #copiesBoxItemID
            _GetCtlHandleFromID
            pulllong ParamLongA         ;"Copies" item's handle in ParamLongA
            brl    CoJoSetLEAndGotoLoop ;go get LE hdl and go to event loop

*Event loop which gets mouseclicks/keys and controls animation:
CoJoEventLoop pushlong ParamLongA       ;blink a cursor
            _LEIdle
CoJoDoTasks pha                         ;result space
            pushword #$FFFF             ;event mask
            pushlong #DialogTaskRecord  ;where to stuff event data
            _TaskMaster                 ;do events
            pla

*Do redrawing of controls for update event, if necessary:
            cmp    #6                   ;update event?
            bne    CoJoNotUpdate
            ldx    DialogWindowPtr+0    ;check if it's our window
            cpx    DialogTaskData+0
            bne    CoJoNotUpdate
            ldy    DialogWindowPtr+2
            cpy    DialogTaskData+2
            bne    CoJoNotUpdate
            phy                         ;redraw all contents
            phx
            _BeginUpdate
            jsr    RedrawDialog
            pushlong DialogWindowPtr
            _EndUpdate
            bra    CoJoEventLoop
CoJoNotUpdate ANOP

*Check for mousedown in a control or if a key was hit:
            cmp    #$0021               ;wInControl?
            bne    CoJoNotInCtrl
            brl    CoJoCheckCtrls
CoJoNotInCtrl cmp  #$0003               ;keyDownEvt?
            bne    CoJoEventLoop

*A key has been hit; do OK/Cancel hilite ourselves if selected because not
*going thru taskmaster:
            lda    DialogMessage
            cmp    #okItemKeyEquiv
            bne    CoJoNotKeyOk
            pha
            pha
            pushlong DialogWindowPtr
            pushlong #okItemID
            _GetCtlHandleFromID
            pulllong ParamLongA         ;clobber this, but we're out anyway
            pushword #1
            pushlong ParamLongA
            _HiliteControl
            pushword #0
            pushlong ParamLongA
            _HiliteControl
            brl    CoJoOk
CoJoNotKeyOk cmp   #cancelItemKeyEquiv
            bne    CoJoNotKeyCancel
            pha
            pha
            pushlong DialogWindowPtr
            pushlong #cancelItemID
            _GetCtlHandleFromID
            pulllong ParamLongA         ;clobber this, but we're out anyway
            pushword #1
            pushlong ParamLongA
            _HiliteControl
            pushword #0
            pushlong ParamLongA
            _HiliteControl
            brl    CoJoCancel
CoJoNotKeyCancel ANOP

*If TAB and proper LEHandle, try to move insertion point to another box:
            cmp    #9                   ;TAB key?
            bne    CoJoNotKeyTab        ;not TAB key
            pushlong ParamLongA         ;save old LE handle on stack
*                           
            pha                         ;get "From" ctl hdl in ParamLongA
            pha
            pushlong DialogWindowPtr
            pushlong #pagesFromBoxItemID
            _GetCtlHandleFromID
            pulllong ParamLongA
*       
            lda    [ParamLongA]         ;cmp to see if old LEH == "From" LEH
            tax
            ldy    #2
            lda    [ParamLongA],y
            sta    ParamLongA+2
            stx    ParamLongA
            ldy    #octlData            ;offset into ctrl rec for LE handle
            lda    [ParamLongA],y       ;lo order word of LE handle
            cmp    1,s                  ;cmp to current LE handle lo
            bne    CoJoNotKeyTabLEH
            iny
            iny
            lda    [ParamLongA],y       ;hi order word of LE handle
            cmp    3,s                  ;cmp to current LE handle hi
            bne    CoJoNotKeyTabLEH
*
            pla                         ;yes, in "From" so yank old LE handle
            pla
*
            pha                         ;and make "To" box the active one
            pha
            pushlong DialogWindowPtr
            pushlong #pagesToBoxItemID
            _GetCtlHandleFromID
            pulllong ParamLongA         ;get "To" ctl hdl in ParamLongA
            pushlong ParamLongA         ;do screen animation
            _MakeThisCtlTarget
            brl    CoJoSetLEAndGotoLoop  ;get LE hdl from ctl hdl and loop
*
CoJoNotKeyTabLEH pulllong ParamLongA    ;didn't  restore old LE handle
CoJoNotKeyTab ANOP

*Not OK/Cancel/TAB, so if we have LEHandle, filter out '0'..'9'/LE cmd keys
*and call LEKey:
            lda    DialogMessage        ;look at keystroke ascii code
            shortmx
            ldy    #15
CoJoCheckKeyLoop cmp CoJoLEKeyTable,y   ;is it a key we should handle?
            beq    CoJoLEKey
            dey
            bpl    CoJoCheckKeyLoop
            longmx
            brl    CoJoEventLoop
CoJoLEKeyTable dc  i1'8,21,127'
             dc    i1'6,24,25'
             dc    c'0123456789'
CoJoLEKey   longmx
            pushword DialogMessage
            pushword DialogModifiers
            pushlong ParamLongA
            _LEKey
            brl    CoJoEventLoop

*Check if any new LE text boxes were selected; also change All/From-To radio
*buttons:
CoJoCheckCtrls lda DialogTaskData4      ;get lo order control item ID
            cmp    #pagesFromBoxItemID
            beq    CoJoFromToBox
CoJoNotFromBox cmp #pagesToBoxItemID
            bne    CoJoNotToBox
CoJoFromToBox pushword #0               ;switch All/From-To radio button
            pha
            pha
            pushlong DialogWindowPtr
            pushlong #pagesAllItemID
            _GetCtlHandleFromID
            _SetCtlValue                ;turn "All" radio button off
            pushword #1
            pha
            pha
            pushlong DialogWindowPtr
            pushlong #pagesRangeItemID
            _GetCtlHandleFromID
            _SetCtlValue                ;turn the other radio button on
            bra    CoJoItsBox
CoJoNotToBox cmp   #copiesBoxItemID
            bne    CoJoNoLEBoxes

*We selected a box; get its LE handle:
CoJoItsBox  lda    DialogTaskData2+0    ;get handle to control record
            sta    ParamLongA+0         ;and drop into next section below
            lda    DialogTaskData2+2
            sta    ParamLongA+2

*Get LE handle from ctl handle and then go to event loop:
CoJoSetLEAndGotoLoop lda [ParamLongA]   ;this section transforms the control
            tax                         ;handle of a LE item into a valid
            ldy    #2                   ;LE handle for that item
            lda    [ParamLongA],y
            sta    ParamLongA+2
            stx    ParamLongA+0
            ldy    #octlData            ;offset into ctrl rec for LE handle
            lda    [ParamLongA],y       ;lo order word of LE handle
            tax
            iny
            iny
            lda    [ParamLongA],y       ;hi order word of LE handle
            sta    ParamLongA+2
            stx    ParamLongA+0         ;ParamLongA now has LE handle
            brl    CoJoEventLoop

*If no boxes were clicked, since we got wInControl, check for other
*possibilities:
CoJoNoLEBoxes ANOP

*Exit without affecting print record if Cancel select:
            cmp    #cancelItemID
            bne    CoJoNotCancel
CoJoCancel  jsr    FinishDialog            ;dump dialog box
            lda    #0                      ;confirmFlag will be false
            rts

*If OK select, save data in print record; else resume event handling:
CoJoNotCancel cmp  #okItemID
            beq    CoJoOk
            brl    CoJoEventLoop
*
CoJoOk      lda    #printQualityItemID
            jsr    GetControlValue
            sec
            sbc    #printQualityStandardItemID ;normalize
            sta    OptionA
            jsr    SetQuality
*
            lda    #chromaItemID
            jsr    GetControlValue
            sec
            sbc    #chromaMonochromeItemID     ;normalize
            sta    OptionA
            jsr    SetColor
*
            lda    #pageFeedItemID
            jsr    GetControlValue
            sec
            sbc    #pageFeedManualItemID     ;normalize
            sta    OptionA
            jsr    SetFeed

*Initially assume default values for both parts of the page range:
            lda    #1
            sta    OptionA
            lda    #32767
            sta    OptionB

*If "All" page range option selected, skip the following few sections:
            lda    #pagesAllItemID
            jsr    GetControlValue
            cmp    #1
            beq    CoJoSetPageRange

*"All" not selected, so get each part of the page range only if nonzero.
*Pin on upper limit:
            lda    #pagesFromBoxItemID  ;convert "From" string to number
            jsr    GetBoxValue
            cmp    #0                   ;if zero, keep our default
            beq    CoJoDontConsiderPgRngA
            cmp    #32768               ;pin to largest value and store
            bcc    CoJoConsiderPgRngA
            lda    #32767
CoJoConsiderPgRngA sta OptionA
CoJoDontConsiderPgRngA ANOP
            lda    #pagesToBoxItemID    ;convert "To" string to number
            jsr    GetBoxValue
            cmp    #0                   ;if zero, keep our default
            beq    CoJoDontConsiderPgRngB
            cmp    #32768               ;pin to largest value and store
            bcc    CoJoConsiderPgRngB
            lda    #32767
CoJoConsiderPgRngB sta OptionB
CoJoDontConsiderPgRngB ANOP

*With first page in OptionA and last page in OptionB, see if backwards:
            lda    OptionB
            cmp    OptionA              ;check page range
            bcs    CoJoPageRangeNotBackwards ;at it's least not backwards
            ldx    OptionA              ;else exchange A,B...
            sta    OptionA
            stx    OptionB
CoJoPageRangeNotBackwards ANOP

*With sane values for first page in OptionA and last page in OptionB, set
*the page range:
CoJoSetPageRange jsr SetPageRange

*Set number of copies, pinning to largest possible value and ensuring nonzero:
            lda    #copiesBoxItemID     ;convert "Copies" str to number
            jsr    GetBoxValue
            cmp    #32768               ;pin within range 1..32767...
            bcc    CoJoNoPinCopies1
            lda    #32767
CoJoNoPinCopies1 cmp #0
            bne    CoJoNoPinCopies2
            lda    #1
CoJoNoPinCopies2 sta OptionA
            jsr    SetCopies

*Dump dialog box, validate print record because it changed, and exit with
*ACC set:
            jsr    FinishDialog         ;dump the box
            jsr    CalcMetrics
            lda    #1                   ;confirmFlag will be true
            rts

            END

*
*SUBROUTINES: Used by routines above to perform various setup/shutdown and
*repeated tasks:
*

*
*STARTDIALOG: Draws our standard dialog window; fills with control list
*given by "ParamLongA":
*
StartDialog START
            USING  PicterData

            pha                         ;result space for old grafport
            pha
            _GetPort
            pulllong OldGrafPortPtr     ;save old grafport pointer

*Modify coordinates of dialog window to suit 320/640 mode:
            lda    WindowCoordX2
            sec
            sbc    WindowCoordX1        ;calc box size (silly at runtime)
            sta    ParamWordA           ;save size
            pha                         ;result space for scb
            _GetMasterSCB
            pla
            ldx    #640                 ;assume 640 mode for a sec
            and    #$80                 ;look at mode bit (1=640, 0=320)
            bne    StDiMode640
            ldx    #320                 ;change assumption made above
StDiMode640 txa
            sec
            sbc    ParamWordA           ;a-reg now has [320|640] - (X2-X1)
            lsr    a                    ;divide by two
            sta    WindowCoordX1        ;this is left coordinate of box
            clc
            adc    ParamWordA           ;maintain proper box size
            sta    WindowCoordX2        ;this is right coordinate of box

*Draw the window on the screen and set as current port:
            pushlong #0                 ;result space for window grafportptr
            pushlong #WindowTemp
            _NewWindow                  ;draw window from template
            lda    1,s                  ;keep on stack for SetPort only
            sta    DialogWindowPtr+0    ;and also save it away
            lda    3,s
            sta    DialogWindowPtr+2
            _SetPort                    ;set our window as current port

*Create (but don't draw yet) the controls in the window using the given
*control template:
            pushlong #0                 ;result space
            pushlong DialogWindowPtr    ;window's grafport to draw in
            pushword #3                 ;ptrToPtr input reference
            pushlong ParamLongA         ;get desired control template
            _NewControl2
            pla                         ;we don't need these zeros
            pla

*Draw the controls and exit:
            jsr    RedrawDialog
            rts

            END

*
*REDRAWDIALOG: Call this routine to redraw contents of window (during update
*event, for example):
*
RedrawDialog START
             USING PicterData

             pushlong DialogWindowPtr
            _DrawControls               ;fill window with controls...
            pushword #1                 ;draw horizontal adornment line...
            pushword #2
            _SetPenSize
            pushword #WindowLineX1
            pushword #WindowLineY
            _MoveTo
            pushword #WindowLineX2
            pushword #WindowLineY
            _LineTo
            _InitCursor                 ;ensure arrow cursor...
            rts

            END

*
*FINISHDIALOG: Call this routine when done with dialog; erases
*window/controls and releases memory:
*
FinishDialog START
            USING  PicterData

            pushlong DialogWindowPtr
            _CloseWindow                ;erase window and dispose memory
            pushlong OldGrafPortPtr     ;get old port pointer
            _SetPort                    ;restore it
            rts

            END

*
*GETOUTPUTPORTNAME: Routine which sets up "XXX" part in "PICTER/XXX" in
*dialog data:
*
GetOutputPortName START
            USING  PicterData

            pha
            pha
            ldx    #$2913               ;get pointer to str w/ port name
            jsl    $E10000              ;_PMGetPortName
            pulllong ParamLongA
            shortmx
            lda    [ParamLongA]
            tay
            clc
            adc    #PortTitleLenOrig    ;store correct length of full...
            sta    PortTitleLen         ;...port title...
GePoNaStrCpy lda   [ParamLongA],y       ;and  PRINTER, etc., string
            sta    PortTitleStr-1,y
            dey
            bne    GePoNaStrCpy
            longm
            longx
            rts

            END

*
*DIMPOPUPITEM: Dims pop-up menu item. Menu_ctl_ID -> ParamWordA,
*Menu_ctl_item_ID -> ParamWordB:
*

;
; This isn't actually used by the picter driver, but it's handy to
; have around...

DimPopUpItem START
            USING  PicterData

            pha                        ;save menu bar hdl on stack...
            pha
            _GetMenuBar
            pha                         ;result space...
            pha                         ;...for GetCtlHandleFromID
            pushlong DialogWindowPtr    ;pass window pointer
            pushword #0                 ;pass hi order word of ID
            pushword ParamWordA         ;pass lo order word of ID
            _GetCtlHandleFromID         ;get pop-up control handle...
            _SetMenuBar                 ;...and set as current menu bar
            pushword ParamWordB         ;now that menu mgr knows about
            _DisableMItem               ;our control, disable item
            _SetMenuBar                 ;...restore menu bar from stack
            rts

            END

*
*GETCONTROLVALUE: Obtains control state. Put ID lo order word -> ACC; on
*exit, ACC -> control value:
*
GetControlValue START
            USING PicterData

            sta ParamWordA          ;save  use in a second
            pha                         ;result space for GetCtlValue
            pha                         ;result space...
            pha                         ;...for GetCtlHandleFromID
            pushlong DialogWindowPtr    ;pass window pointer
            pushword #0                 ;pass hi order word of ID
            pushword ParamWordA         ;pass lo order word of ID
            _GetCtlHandleFromID         ;get handle
            _GetCtlValue                ;use handle to get value
            pla                         ;leave value in accumulator
            rts
            END

*
*GETBOXVALUE: Gets integer from LineEdit control.  Put ID lo order -> ACC;
*on exit, ACC -> integer:
*
GetBoxValue START
            USING  PicterData

            sta    ParamWordA           ;save for use in a second
            pha                         ;result space for GetCtlValue...
            pha                         ;...result space
            pushlong DialogWindowPtr    ;pass window pointer
            pushword #0                 ;pass hi order word of ID
            pushword ParamWordA         ;pass lo order word of ID
            _GetCtlHandleFromID         ;get handle to control record
            pulllong ParamLongA         ;get it off stack into dp
            lda    [ParamLongA]         ;dereference the handle
            tax
            ldy    #2
            lda    [ParamLongA],y
            sta    ParamLongA+2
            stx    ParamLongA           ;ParamLongA is now a pointer
            ldy    #octlData            ;offset ctrl rec for LE handle
            lda    [ParamLongA],y
            tax
            iny
            iny
            lda    [ParamLongA],y       ;a,x now has LE handle
            pha                         ;result space for LEGetTextHand
            pha                         ;result space for LEGetTextHand
            pha                         ;hi LE handle for LEGetTextHand
            phx                         ;lo LE handle for LEGetTextHand
            pha                         ;result space for LEGetTextLen
            pha                         ;hi LE handle for LEGetTextLen
            phx                         ;lo LE handle for LEGetTextLen
            _LEGetTextLen               ;get length of our text line
            pullword ParamWordA         ;save length for use in a sec
            _LEGetTextHand              ;get handle to our text line
            pulllong ParamLongA         ;get it off stack into dp
            lda    [ParamLongA]         ;dereference the handle again
            tax
            ldy    #2
            lda    [ParamLongA],y
            sta    ParamLongA+2
            stx    ParamLongA           ;we now have pointer to string!
            pha                         ;result space
            pushlong ParamLongA         ;pass the pointer
            pushword ParamWordA         ;pass string length
            pushword #0                 ;pass that this is unsigned
            _Dec2Int                    ;convert ascii to word
            pla                         ;get result in accumulator
            rts

            END
